<?php

namespace Import\ApiBundle\Services\Import;


use Import\ApiBundle\Entity\DelegationCost;
use Import\ApiBundle\Entity\IncomeTax;
use Import\ApiBundle\Entity\IncomeTaxRate;
use Import\ApiBundle\Entity\VehicleCost;

class ImportVehicleCosts extends ImportMainService
{
    protected $url = 'http://www.wskazniki.pl/?doc_id=14111&iid=5794';

    protected $columns = array("Nazwa","Value");

    public function import()
    {
        $this->type = 'ImportVehicleCosts';
        $data = $this->getTableWithoutHeaderFromPage($this->url,$this->columns);

        foreach($data as $id => $row)
        {
            if($this->validRow($row))
            {
                $row = $this->addDataToRow($row);
                if(empty($row))
                {
                    $this->addError(3,$data[$id],$this->type);
                    unset($data[$id]);
                }
                else
                {
                    $data[$id] = $row;
                }
            }
            else
            {
                unset($data[$id]);
            }
        }
        $count = $this->save($data);
        $this->viewErrors();

        return array('count' => $count);
    }

    protected function validRow($row)
    {
        $valid = true;

        foreach($this->columns as $column)
        {
            if(!isset($column) || $row[$column] == '')
            {
                $valid = false;
                $this->addError(1,$column,$this->type);
            }
        }

        return $valid;
    }

    protected function addDataToRow($row)
    {
        $i = 0;
        $data = $row[$this->columns[$i]];
        $data = trim($data);
        $row[$this->columns[$i]] = $data;

        $i = 1;
        $data = $row[$this->columns[$i]];
        if($data == '&nbsp;' || $data == '')
        {
            $data = 0;
        }
        $data = str_replace('&nbsp;', '', $data);
        $data = str_replace('zł','',$data);
        $data = str_replace(',','.',$data);
        $data = trim($data);
        $row[$this->columns[$i]] = $data;

        return $row;
    }

    protected function save($data)
    {
        foreach($data as $row)
        {
            $vehicleCost = $this->getDoctrine()->getRepository('ImportApiBundle:VehicleCost')->findOneBy(array('vehicle_name' => $row['Nazwa']));

            if(empty($vehicleCost))
            {
                $vehicleCost = new VehicleCost();
            }

            $vehicleCost->setVehicleName($row['Nazwa']);
            $vehicleCost->setCost($row['Value']);
            $vehicleCost->setCreateAt(new \DateTime());

            $this->getDoctrine()->getEntityManager()->persist($vehicleCost);
        }
        $this->getDoctrine()->getEntityManager()->flush();

        return count($data);
    }
}